#include <algorithm>
#include <iostream>
#include <vector>

using namespace std;

struct Mast {
    int id;
    long long x;
    long long h;
};

bool compare(const Mast &a, const Mast &b) { return a.x < b.x; }

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n;
    cin >> n;
    vector<Mast> masts(n);
    vector<long long> result(n, -1);

    for (int i = 0; i < n; i++) {
        masts[i].id = i;
        cin >> masts[i].x;
    }

    for (int i = 0; i < n; i++) {
        cin >> masts[i].h;
    }

    vector<int> stack;
    stack.reserve(n);
    sort(masts.begin(), masts.end(), compare);
    for (int i = 0; i < n; i++) {
        while (!stack.empty() && masts[stack.back()].h < masts[i].h) {
            stack.pop_back();
        }

        if (!stack.empty()) {
            int j = stack.back();
            result[masts[i].id] = masts[i].x - (masts[j].x + masts[j].h - masts[i].h);
        }

        stack.push_back(i);
    }

    stack.clear();
    for (int i = n - 1; i >= 0; i--) {
        while (!stack.empty() && masts[stack.back()].h < masts[i].h) {
            stack.pop_back();
        }

        if (!stack.empty()) {
            int j = stack.back();
            long long dist = (masts[j].x - masts[j].h + masts[i].h) - masts[i].x;
            if (result[masts[i].id] == -1 || dist < result[masts[i].id]) result[masts[i].id] = dist;
        }

        stack.push_back(i);
    }

    for (auto res : result) {
        cout << res << endl;
    }

    return 0;
}